unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, MMPlot_u,Printers, Spin, ExtCtrls,
  unit2, unit3;

type
  TForm1 = class(TForm)
    MMPlot1: TMMPlot;
    Button1: TButton;
    Button2: TButton;
    sbh: TScrollBar;
    sbv: TScrollBar;
    Button3: TButton;
    rgv: TRadioGroup;
    rgh: TRadioGroup;
    FontDialogP: TFontDialog;
    Button4: TButton;
    Button5: TButton;
    sbX: TScrollBar;
    sbY: TScrollBar;
    sbBorder: TScrollBar;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure PosChange(Sender: TObject);
    procedure rgvClick(Sender: TObject);
    procedure rghClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure BorderChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses Main;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  MMplot1.Active := false;
  MMPlot1.PrintControl := FALSE;
  MMPlot1.ZoomAll;
  Printer.BeginDoc;
  MMPlot1.Options := MMPlot1.Options + [goPrint];
  try
    MMPlot1.Show(Printer);
    Printer.Canvas.TextOut(100,100, 'Using MMPlot is quite easy');
  finally
  Printer.EndDoc;
  end;
  MMPlot1.Options := MMPlot1.Options - [goPrint];
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  MMplot1.Active := true;
  MMplot1.zoomall;
  Refresh;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  Canvas.TextOut(100,100, 'Using MMPlot is quite easy');
end;

procedure TForm1.PosChange(Sender: TObject);
begin
  MMPlot1.Topleft := Point(sbh.position,sbv.position);
  MMPlot1.Bottomright := Point(sbh.position+sby.position,sbv.position+sbx.position);
end;

procedure TForm1.rgvClick(Sender: TObject);
begin
  sbv.enabled := false;
  sby.enabled := false;
  MMPlot1.BorderY := sbborder.position;
  case rgv.itemindex of
    0: MMPlot1.Align.vertical := vaTop;
    1: MMPlot1.Align.vertical := vaCenter;
    2: MMPlot1.Align.vertical := vaBottom;
    3: begin
         MMPlot1.Align.vertical := vaPosition;
         MMPlot1.BorderY := 4;
         sbv.enabled := true;
         sby.enabled := true;
         PosChange(Sender);
       end;
  end;
end;

procedure TForm1.rghClick(Sender: TObject);
begin
  sbh.enabled := false;
  sbx.enabled := false;
  MMPlot1.BorderX := sbborder.position;
  case rgh.itemindex of
    0: MMPlot1.Align.horizontal := haLeft;
    1: MMPlot1.Align.horizontal := haCenter;
    2: MMPlot1.Align.horizontal := haRight;
    3: begin
         MMPlot1.Align.horizontal := haPosition;
         MMPlot1.BorderX := 4;
         sbh.enabled := true;
         sbx.enabled := true;
         PosChange(Sender);
       end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  If FontdialogP.execute then with Printer.Canvas.Font do
  begin
    Name := FontdialogP.Font.Name;
    Size := FontdialogP.Font.Size;
    Height := FontdialogP.Font.Height;
    Style := FontdialogP.Font.Style;
    Pitch := FontdialogP.Font.Pitch;
    Color := FontdialogP.Font.Color;
  end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  Form2.Show;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Form3.Show;
end;

procedure TForm1.BorderChange(Sender: TObject);
begin
  if rgh.itemindex < 3 then MMPlot1.BorderX := sbborder.position;
  if rgv.itemindex < 3 then MMPlot1.BorderY := sbborder.position;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  MMPlot1.GraphDir := Mainform.MMPlot1.GraphDir;
  MMPlot1.Graphname := Mainform.MMPlot1.Graphname;
  BorderChange(Sender);
end;

end.
